use strict;
use warnings;

#
# constants
####################
use constant TYPE_SET	   => 'set';
use constant TYPE_SET_RSP  => 'set rsp';
use constant TYPE_QUERY    => 'query';
use constant TYPE_TEST 	   => 'test';
use constant TYPE_UNS 	   => 'uns';
use constant TYPE_GLOB     => 'glob';

sub usage {
print <<HERE_TARGET;
AT Command Syntax Compiler v1.0
-------------------------------
Usage perl gen.pl [OPTIONS]

  -h      	   This help text
  -v      	   Version number
  -f <extension>   Controls the syntax file name, "cmd_list_<extension>.log"
                   Default is "_latest"

  
Example:

The following line process a syntax file with the following name "cmd_list_myVersion.log"

perl gen.pl -f myVersion

HERE_TARGET
exit(1);
}

my $use_enum = 1; #default is use of enumerations

if (defined $ARGV[0] && $ARGV[0] eq '-h') {
	usage();
}

if (defined $ARGV[0] && $ARGV[0] eq '-v') {
print <<HERE_TARGET;
AT Command Syntax Compiler v1.0
HERE_TARGET
exit(1);
}

my $syntaxFileExtension = '_latest';
if (defined $ARGV[0] && $ARGV[0] eq '-f'&& defined $ARGV[1]) {
	$syntaxFileExtension = $ARGV[1];
} elsif (defined $ARGV[0]) {
	usage();
}

#print $use_enum;


#
# declarations
#####################
sub bat_ValuesSection(\%);
sub bat_PrimBasicElementsSection(\%);
sub bat_PrimStructElementsSection(\%);
sub print_structured_element(\%);
sub bat_ConstantsSection(\%);

my $dump = 0;
#
# subs
####################
sub read_command_list($\%);
sub ATsort {
	my ($A, $B) = ($a , $b);
	$A =~ s/[+%&]//;
	$B =~ s/[+%&]//;
	$A =~ s/shared/1/;
	$B =~ s/shared/1/;
	if($A cmp $B) {
		$A cmp $B;
	} else {
		$a cmp $b;
	}
}
sub logging {
	my ($log, @param) = @_;
	#*LOG;
	
	if(! exists $::logdb{$log}) {
		open LOG, ">$log.log" or die "konnte $log nicht zum schreiben oeffnen";
		$::logdb{$log} = \*LOG;
	}
	
	*LOG = $::logdb{$log};
	print LOG @param;
}

sub debug_bat(\%) {
	#no warnings;
	my $pbat = shift;
	my $debug = '';
	my %param;

sub sub_debug_bat($$$$\%) {
	my ($pbat, $cmd, $type, $type_string, $pparam) = @_;
	my $debug = '';
	#print "$cmd ($type): ", join "-", keys %{$pbat->{$cmd}}, "\n";
	if(exists $pbat->{$cmd}{$type}) {
		#print "$cmd: $type\n";
		$debug .= "[$type_string\n";
		my $param;
		for $param (@{$pbat->{$cmd}{$type}{params}}) {
			#print "$cmd: $param\n";
			if(exists $pparam->{$param}) {
				$debug .= "-$param";
				$debug .= " : $pbat->{$cmd}{$type}{param_def}{$param}{type}" if (exists $pbat->{$cmd}{$type}{param_def}{$param}{type});
				$debug .= " : $pbat->{$cmd}{$type}{param_def}{$param}{occu}" if (exists $pbat->{$cmd}{$type}{param_def}{$param}{occu});
				$debug .= "\n";
				#print "H-$param\n";
			} else {
				no warnings;
				if(! exists $pbat->{$cmd}{param_def}{$param}{ref}){
					if($cmd eq 'shared') {
						$debug .= "-$param : $pbat->{$cmd}{param_def}{$param}{short} : $pbat->{$cmd}{param_def}{$param}{type} : $pbat->{$cmd}{param_def}{$param}{descr}\n";
					} else {
						$debug .= "-$param : $pbat->{$cmd}{param_def}{$param}{short} : $pbat->{$cmd}{param_def}{$param}{type} : $pbat->{$cmd}{param_def}{$param}{occu} : $pbat->{$cmd}{param_def}{$param}{descr}\n";
					}
				} else {
					$debug .= "-$param : REF".'@'."$pbat->{$cmd}{param_def}{$param}{ref}";
					$debug .= '@'."$pbat->{$cmd}{param_def}{$param}{ref_name}" if(exists $pbat->{$cmd}{param_def}{$param}{ref_name});
					$debug .= " : $pbat->{$cmd}{$type}{param_def}{$param}{type}" if (exists $pbat->{$cmd}{$type}{param_def}{$param}{type});
					$debug .= " : $pbat->{$cmd}{$type}{param_def}{$param}{occu}" if (exists $pbat->{$cmd}{$type}{param_def}{$param}{occu});				
					$debug .= "\n";
				}
				$pparam->{$param} = 1;
				
				if(exists $pbat->{$cmd}{value_def}{$param}) {
					my $pvalue;
					for $pvalue (@{$pbat->{$cmd}{value_def}{$param}}) {
						$debug .= "$pvalue->{value} : $pvalue->{short} : $pvalue->{long}\n" if (defined $pvalue);
					}
				}
			}
		}
	$debug .= "]\n";
	}
}
#					$pbat->{$cmd}{$struct_type}{param_def}{occu} = $details[2];
#					$pbat->{$cmd}{param_def}{$param}{type}  = $details[1];
		
	my $cmd;
	for $cmd (sort ATsort keys %{$pbat}) {
		print STDERR "ERROR: NO description: $cmd\n" if(! defined $pbat->{$cmd}{descr});
		$debug .= "{\n$cmd : $pbat->{$cmd}{descr}\n";		
		
		$debug .= sub_debug_bat($pbat, $cmd, TYPE_SET,     'cmd',       %param);
		$debug .= sub_debug_bat($pbat, $cmd, TYPE_SET_RSP, 'cmd rsp',   %param);
		$debug .= sub_debug_bat($pbat, $cmd, TYPE_QUERY,   'query rsp', %param);
		$debug .= sub_debug_bat($pbat, $cmd, TYPE_TEST,    'test rsp',  %param);
		$debug .= sub_debug_bat($pbat, $cmd, TYPE_UNS,     'uns rsp',   %param);
		$debug .= sub_debug_bat($pbat, $cmd, TYPE_GLOB,    'glob',      %param);

		undef %param;
		
		$debug .= "}\n\n";
	}
	$debug;
}



#
# globals
####################
my %bat; #description of BAT commands
#use constant USE_ENUM => 0;	
my (%enum, %param, %array); # the optional mandatory hack



my ($andy_def, $andy_undef) = read_command_list('sources\cmd_list' . $syntaxFileExtension . '.log', %bat);

open FILE, '>sap.txt';
print FILE bat_ConstantsSection %bat;
print FILE bat_PrimStructElementsSection %bat;
print FILE bat_PrimBasicElementsSection %bat;
print FILE bat_ValuesSection %bat;
print FILE "</SAP>\n";
close FILE;
	
	

create_bat_sap_document();

sub create_bat_sap_document {
	system('type sources\Header.txt >  result\bat.sap');
#	system('type D:\brz\Paris\AlcatelApp\APIgen\batII\sap\param.txt  >>  Z:\g23m\condat\ms\doc\sap\bat.sap');
#	system('type D:\brz\Paris\AlcatelApp\APIgen\batII\sap\structs.txt >> Z:\g23m\condat\ms\doc\sap\bat.sap');
	system('type sap.txt >> result\bat.sap');
#	system('type D:\brz\Paris\AlcatelApp\APIgen\batII\sap\BasicEle.txt >>  Z:\g23m\condat\ms\doc\sap\bat.sap');
#	system('type D:\brz\Paris\AlcatelApp\APIgen\batII\sap\values.txt >>  Z:\g23m\condat\ms\doc\sap\bat.sap');
}
open FILE, '>D:\brz\Paris\AlcatelApp\APIgen\batIII\sap\result\cmd_list.log'; 
print FILE debug_bat %bat;
close FILE;

sub read_command_list($\%) {
use constant CL_ERROR 			=> -1;	
use constant CL_SEARCH_CMD 		=> 0;	
use constant CL_READ_CMD_NAME 		=> 1;	
use constant CL_SEARCH_STRUCTS 		=> 2;	
use constant CL_READ_CMD_STRUCT     	=> 3;	
use constant CL_READ_CMD_RSP_STRUCT    	=> 4;	
use constant CL_READ_QUERY_STRUCT   	=> 5;	
use constant CL_READ_TEST_STRUCT    	=> 6;	
use constant CL_READ_UNS_RES_STRUCT 	=> 7;	
use constant CL_READ_SHARED_PARAM 	=> 8;	

use constant RP_ERROR 			=> -1;	
use constant RP_SEARCH_PARAM 		=> 0;	
use constant RP_PARAM_RED  	 	=> 1;	
use constant RP_VALUE_RED 		=> 2;	

sub read_param_representation($) {
	local $_ = shift;

	s/\@empty//;
	lc $_;
}

	my ($file, $pbat) = @_;
	
	my $cmd; 
	my ($cl_state, $last_cl_state) = (CL_SEARCH_CMD, CL_ERROR);
	my ($rp_state, $last_rp_state) = (RP_SEARCH_PARAM, RP_ERROR);

	sub add_bat_param {
		my ($pbat, $cmd, $cl_state, $pparam) = @_;
	}
	
	my %param;
	my ($cparam, $cvalue) = (0, 0);
	my ($struct_type, $param);
	open FILE, $file or die "Can not open file $file: $!n";

	my ($def_cmd, $undef_cmd, $def_param) = (0, 0, 0);
	my @warning_line_buffer;
	my $buffered_lines = 5;
	my $line_number = 0;
	my $occurance = 'man';
	while(<FILE>) {
		$line_number++;
		#print;
		##############################
		# line buffering for warnings
		my $i;
		for $i (0..($buffered_lines)) {
			$warning_line_buffer[$i] = $warning_line_buffer[$i+1];
		}
		$warning_line_buffer[$buffered_lines] = $_;
		
		##############################
		chomp;
		next if(/^##/); # comment
		
		if(/^\s*\{/) {
			$last_cl_state = $cl_state;
			$cl_state = CL_SEARCH_CMD == $cl_state ? CL_READ_CMD_NAME : CL_ERROR;
			next;
		}
		if ($cl_state == CL_READ_CMD_NAME) {
			$last_cl_state = $cl_state;
			/([^:]+):\s*(.+)\s*/;
			#print "$_\n";
			$cmd = $1;
			my $descr = $2;
			$cmd =~ s/^\s*//;
			$cmd =~ s/\s*$//;
			$cmd =~ s/\s/_/g;
			if(!exists $pbat->{$cmd}) {
				$pbat->{$cmd}{descr} = $descr;
				$cl_state = CL_SEARCH_STRUCTS;
			} else {
				$cl_state = CL_ERROR;
			}
			#print "$cmd* *$pbat->{$cmd}{descr}*\n";
			next;
		}
				
		if(/^\s*\}/) {
			if($def_param) {
				$def_cmd ++;
			} else {
				$undef_cmd ++;
			}
			$def_param = 0;

			$last_cl_state = $cl_state;
			$cl_state = (CL_SEARCH_STRUCTS == $cl_state) ? CL_SEARCH_CMD : CL_ERROR;
			($cparam, $cvalue) = (0, 0);
			next;
		}
		
		if(/^\s*\[\s*cmd rsp/){
			$last_cl_state = $cl_state;
			$cl_state = CL_SEARCH_STRUCTS == $cl_state ? CL_READ_CMD_RSP_STRUCT : CL_ERROR;
			$struct_type = TYPE_SET_RSP;
			next;
		}
		if(/^\s*\[\s*cmd/){
			$last_cl_state = $cl_state;
			$cl_state = CL_SEARCH_STRUCTS == $cl_state ? CL_READ_CMD_STRUCT : CL_ERROR;
			$struct_type = TYPE_SET;
			next;
		}
		if(/^\s*\[\s*query/){
			$last_cl_state = $cl_state;
			$cl_state = CL_SEARCH_STRUCTS == $cl_state ? CL_READ_QUERY_STRUCT : CL_ERROR;
			$struct_type = TYPE_QUERY;
			next;
		}
		if(/^\s*\[\s*test/){
			$last_cl_state = $cl_state;
			$cl_state = CL_SEARCH_STRUCTS == $cl_state ? CL_READ_TEST_STRUCT : CL_ERROR;
			$struct_type = TYPE_TEST;
			next;
		}
		if(/^\s*\[\s*uns/){
			$last_cl_state = $cl_state;
			$cl_state = CL_SEARCH_STRUCTS == $cl_state ? CL_READ_UNS_RES_STRUCT : CL_ERROR;
			$struct_type = TYPE_UNS;
			#print STDERR "*$cmd\t";
			next;
		}
		if(/^\s*\[\s*glob/ && $cmd eq 'shared'){
			$last_cl_state = $cl_state;
			$cl_state = CL_SEARCH_STRUCTS == $cl_state ? CL_READ_SHARED_PARAM : CL_ERROR;
			$struct_type = TYPE_GLOB;
			next;
		}

		if(/^\s*\]/){
			$last_cl_state = $cl_state;
			$cl_state = (CL_READ_CMD_STRUCT     == $cl_state ||
				     CL_READ_CMD_RSP_STRUCT == $cl_state ||
			             CL_READ_QUERY_STRUCT   == $cl_state ||
			             CL_READ_TEST_STRUCT    == $cl_state ||
			             CL_READ_UNS_RES_STRUCT == $cl_state ||
			             CL_READ_SHARED_PARAM   == $cl_state    ) ? CL_SEARCH_STRUCTS : CL_ERROR;
			$rp_state = RP_SEARCH_PARAM;
			if(0 == $cparam) {
				$pbat->{$cmd}{$struct_type}{without_params} = 1;
			} else {
				$def_param = 1;
			}
			($cparam, $cvalue) = (0, 0);
			next;
		}
		
		if(/^\s*-/) {
			$last_rp_state = $rp_state;
			$rp_state = (CL_READ_CMD_STRUCT     == $cl_state ||
			             CL_READ_CMD_RSP_STRUCT == $cl_state ||
			             CL_READ_QUERY_STRUCT   == $cl_state ||
			             CL_READ_TEST_STRUCT    == $cl_state ||
			             CL_READ_UNS_RES_STRUCT == $cl_state ||
			             CL_READ_SHARED_PARAM   == $cl_state   ) ? RP_PARAM_RED : RP_ERROR;
			/^-(\w+)(.*)/;
			$param = lc $1; #brz lc
			$pbat->{$cmd}{$struct_type}{params}[$cparam++] = $param;
			#print "$cmd $cparam : $param\n";
			my @details = split /:/, $2;
			map{s/^\s*(.*?)\s*$/$1/;} @details;
			my $num_args = $#{[grep /./, @details]};
#			print STDERR "$cmd \t param $num_args\n";
			if(3 == $num_args && 'REF@' ne substr($details[1], 0, 4)) {
				if(exists $pbat->{$cmd}{param_def}{$param}) {
					print STDERR "WARNING: Param not parsed (line: $line_number): $_\n";
				}
				$pbat->{$cmd}{param_def}{$param}{short} 		= lc $details[1];
				$pbat->{$cmd}{param_def}{$param}{type}  		=    $details[2];
				$occurance = $pbat->{$cmd}{param_def}{$param}{occu}  	= lc $details[3];
				$pbat->{$cmd}{param_def}{$param}{descr} 		=    $details[4];
				#print STDERR "$cmd $param : -$details[1]- : -$details[2]- : -$details[3]-\n" if($details[1] eq '@empty');
				next;
			} elsif (defined $details[1] && 'REF@' eq substr($details[1], 0, 4)) { # -cid : REF@shared :opt
				if(exists $pbat->{$cmd}{param_def}{$param}) {
					print STDERR "ERROR: Param not parsed (line: $line_number): $_\n";
				}
				if( $details[1] =~ /^REF@([^@]+)(@(.+))?/) {
					my $ref_to = $1; # brz lc
					if(defined $3) { # REF@ref_to@ref_param_name
						my $ref_param = lc $3; # brz lc
							#print STDERR "??$ref_param???\n";
						if($ref_param =~ /([^@]+)[@]rename/ ) {
							#print STDERR "!!!!!!!!!!!!!!!$ref_to!!$ref_param!!$num_args!!\n";
							$ref_param = lc $1; # brz lc
							#print STDERR "!!!!!!!!!!!!!!!$ref_to!!$ref_param!!$num_args!!\n";
							if(defined $pbat->{$ref_to}{param_def}{$ref_param} && 3 == $num_args) {
								$pbat->{$cmd}{param_def}{$param}{ref} = "$ref_to";
								$pbat->{$cmd}{param_def}{$param}{ref_name} = "$ref_param";
								$pbat->{$cmd}{param_def}{$param}{rename} = "true";								
								$pbat->{$cmd}{$struct_type}{param_def}{$param}{short} = lc $details[2];
								$occurance = $pbat->{$cmd}{$struct_type}{param_def}{$param}{occu}  = lc $details[3];
								$pbat->{$cmd}{$struct_type}{param_def}{$param}{descr} =    $details[4];
								next;
							}
						} else {
							#print STDERR "2!!$ref_to!!$ref_param!!$num_args!!\n";
							if(defined $pbat->{$ref_to}{param_def}{$ref_param}) {
								if(1 == $num_args) {
							#print "////\n";
									$pbat->{$cmd}{param_def}{$param}{ref} = "$ref_to";
									$pbat->{$cmd}{param_def}{$param}{ref_name} = "$ref_param";
									$occurance = $pbat->{$cmd}{$struct_type}{param_def}{$param}{occu}  = lc $details[2];
									next;
									} elsif(2 == $num_args) {
									$pbat->{$cmd}{param_def}{$param}{ref} = "$ref_to";
									$pbat->{$cmd}{param_def}{$param}{ref_name} = "$ref_param";
									$pbat->{$cmd}{$struct_type}{param_def}{$param}{type}  = lc $details[2];
									#print "$cmd $struct_type $param: $pbat->{$cmd}{$struct_type}{param_def}{$param}{type}\n";
									$occurance = $pbat->{$cmd}{$struct_type}{param_def}{$param}{occu}  = lc $details[3];
									next;
								}
							}
						}
					} elsif(defined $pbat->{$ref_to}{param_def}{$param}) {
						#print STDERR "!!!$param!!!\n";
						$pbat->{$cmd}{param_def}{$param}{ref} = $ref_to;
						if (1 == $num_args) {
							$occurance = $pbat->{$cmd}{$struct_type}{param_def}{$param}{occu}  = lc $details[2];
#							{ print STDERR "$cmd, $param, $struct_type --->$ref_to ($occurance)\n" ;}
							next;
						} elsif (2 == $num_args) {
							$pbat->{$cmd}{$struct_type}{param_def}{$param}{type}  =    $details[2];
							$occurance = $pbat->{$cmd}{$struct_type}{param_def}{$param}{occu}  = lc $details[3];
							next;
						} elsif (0 == $num_args) {
							print STDERR "Warning undefined occurance of parameter, mandatory assumed: $cmd - $param\n";
							$occurance = $pbat->{$cmd}{$struct_type}{param_def}{$param}{occu}  = 'man'; # assumed
							next;
						}				
					}
				} 
				print STDERR "WARNING: Param not parsed (line: $line_number) ($num_args, $1, $3): $_\n";
			} elsif (2 == $num_args && 'shared' eq $cmd) {
				$pbat->{$cmd}{param_def}{$param}{short} = lc $details[1];
				$pbat->{$cmd}{param_def}{$param}{type}  =    $details[2];
				$pbat->{$cmd}{param_def}{$param}{descr} =    $details[3];
				next;
			} elsif (1 == $num_args && exists $pbat->{$cmd}{param_def}{$param}) {
				if($details[2] =~ /opt|man/){
					#$pbat->{$cmd}{param_def}{$param}{occu}  = $details[2];
					#$pbat->{$cmd}{param_def}{$param}{type}  = $details[1];
			
					$occurance = $pbat->{$cmd}{$struct_type}{param_def}{$param}{occu}  = lc $details[2];
					$pbat->{$cmd}{$struct_type}{param_def}{$param}{type}  =    $details[1];
					next;
				}
				print STDERR "WARNING: Param not parsed (line: $line_number) ($num_args): $_\n";
			} elsif (0 == $num_args && exists $pbat->{$cmd}{param_def}{$param}) {
				if($details[1] =~ /opt|man/){
					#$pbat->{$cmd}{param_def}{$param}{occu}  = $details[1];
					$occurance = $pbat->{$cmd}{$struct_type}{param_def}{$param}{occu} = lc $details[1];
					next;
				}
				print STDERR "WARNING: Param not parsed (line: $line_number) ($num_args): $_\n";
			} elsif (-1 != $num_args) {
				print STDERR "WARNING: Param not parsed (line: $line_number) ($num_args): $_\n";
			} 
			next;
		}

		if( (CL_READ_CMD_STRUCT     == $cl_state ||
		     CL_READ_CMD_RSP_STRUCT == $cl_state ||
	             CL_READ_QUERY_STRUCT   == $cl_state ||
	             CL_READ_TEST_STRUCT    == $cl_state ||
	             CL_READ_UNS_RES_STRUCT == $cl_state ||
	             CL_READ_SHARED_PARAM   == $cl_state    ) && /^\s*[^-]/) {
			$last_rp_state = $rp_state;
			my @details = split /:/;
			map{s/^\s*(.*?)\s*$/$1/;} @details;
			my $num_args = $#{[grep /./, @details]};
			if(2 == $num_args) {
				$pbat->{$cmd}{value_def}{$param}[$cvalue]{value}  = lc $details[0];
				$pbat->{$cmd}{value_def}{$param}[$cvalue]{short}  = lc $details[1];
				$pbat->{$cmd}{value_def}{$param}[$cvalue++]{long} =    $details[2];
				#print "$param : -$details[0]- : -$details[1]- : -$details[2]-\n";
			} elsif (1 == $num_args) {
				print STDERR "WARNING: Param value not parsed (line: $line_number): $_\n";				
			}
			## no next before this line!!!!!!!!
			$rp_state = RP_SEARCH_PARAM != $rp_state ? RP_VALUE_RED : RP_ERROR;
			next;
		}

		if($cl_state == CL_ERROR) {
			for $i (0..$buffered_lines-1) {
				print$warning_line_buffer[$i];
			}
			die "CL ERROR: $last_cl_state\n$_\n"; 
		} 
		if($rp_state == RP_ERROR) {
			for $i (0..$buffered_lines-1) {
				print$warning_line_buffer[$i];
			}
			die "RP ERROR: $cl_state, $last_rp_state\n$_\n";
		}
	}
	close FILE;
	
	$def_cmd -- if(exists $pbat->{shared});
	($def_cmd, $undef_cmd);
}


###############################################
sub extractTyp($$) {
	my $cmd  = shift;
	local $_ = shift;

	return 'SKIP_ME_PLEASE' if(! defined $_ || $_ eq '' || /DEV_NAME|CAP/);
	die "Not supported basis type in command $cmd: $_\n" if(!/S8|U8|U16|U32|S32|char/);
	
	s/char/U8/;
	/(S8|U8|U16|U32|S32|char)/;
	
	$1;
}
sub basisTyp($$) {
	my $cmd  = shift;
	local $_ = shift;

	$_ = extractTyp $cmd, $_;	
	s/char/U8/;
	$_;
}

sub xml_adaptation($) {
	local $_ = shift;

	if($_)	 {
	s/</&lt;/g;
	s/>/&gt;/g;
	s/&/&amp;/g;
}
	
	$_;
}

sub cmd2Name($) {
	local $_ = shift;
	
	return '' if(/shared/);
	return lc "at_$_" if(!/\+|%|&/);
	s/\+/plus_/;
	s/%/percent_/;
	s/&/and/;
	
	lc "$_";
}

sub shortCmd2Name($) {
	local $_ = cmd2Name $_[0];
	
	s/plus_//;
	s/percent_/p_/;
	
	$_;
}

sub element_name($$) {
	my ($cmd, $param) = @_;
	my $AT_NAME = cmd2Name $cmd;
	my $PARAM   = lc $param;
	
	$AT_NAME? "$AT_NAME\_$PARAM" : $PARAM; 
	
}
sub VAL_name($$) {
	my ($cmd, $param) = @_;
	my $NAME = element_name $cmd, $param;
	
	"VAL_$NAME";
}

sub get_cmd_id($$) {
	my $cmd  = shift;
	my $type = shift;

	my $name = cmd2Name $cmd;
	unless($name =~/plus|percent/) {
		return "\Ucmd_$name";

	}
	my %type = ('set'=>'set', 'query'=>'que', 'test'=>'tst', 'basic'=>'');
	
	return "\Ucmd\_$type{$type}_$name";
}

sub get_rsp_id($$) {
	my $cmd  = shift;
	my $type = shift;

	my $name = cmd2Name $cmd;
	my %type = ('set rsp'=>'set', query=>'que', 'test'=>'tst', 'uns'=>'uns');
#	print STDERR "$name\n";
	return "\Ures\_$name" if($name =~ /busy|connect|no_answer|no_carrier|ok|cm._error/);
	
	return "\Ures\_$type{$type}_$name";
}

sub get_prim_id($$) {
	my $cmd  = shift;
	my $type = shift;

	return get_cmd_id $cmd, $type if($type eq 'set');
	return get_rsp_id $cmd, $type;
}

sub isVALneeded($$$) {
	my ($pbat, $cmd, $param) = @_;
	
	(exists $pbat->{$cmd}{value_def}{$param}) ? 1 : 0;
}




sub bat_ConstantsSection(\%) {
	my $pbat = shift;
	my ($cmd, $param, $const_name, $const_value, %const);

my $debug = <<HERE_TARGET;
    <ConstantsSection>
        <Description>
            <DocElement>
                <XHTMLElement Type="TEXT_SECTION"/>
            </DocElement>
        </Description>
        <Constant>
            <Alias>PARAMETER_NOT_PRESENT</Alias>
            <Value ValueType="DEC">-1</Value>
            <Comment>Constant element</Comment>
        </Constant>
HERE_TARGET


	for $cmd (sort ATsort keys %{$pbat}) {
		for $param (sort ATsort keys %{$pbat->{$cmd}{param_def}}) {
				#print STDERR "$cmd $param $pbat->{$cmd}{param_def}{$param}{type}\n";
			if(exists $pbat->{$cmd}{param_def}{$param}{type}) {
				if($pbat->{$cmd}{param_def}{$param}{type} =~ /(\[.+\])/) {
					local $_ = uc $1;
					#print STDERR "$cmd : $1\n";
					if(/([A-Z][A-Z_0-9]+)/) {
						$const_name = $1;
						if(/=(.+?)\]/) {
							$const_value = $1;
							if($const_value =~ /(\d+)\.+(\d+)/) {
								$const_value = $2;
								$pbat->{$cmd}{param_def}{$param}{array} = "[$1..$const_name]"; 
							} else {
								if(/\[(\d+)\.+/) {
									$pbat->{$cmd}{param_def}{$param}{array} = "[$1..$const_name]"
								} else {
									$pbat->{$cmd}{param_def}{$param}{array} = "[$const_name]";
								}
							}
							if(/\[.+?\](\[.+\])/) {
								$pbat->{$cmd}{param_def}{$param}{array} .= $1;
							}
							#print STDERR "$pbat->{$cmd}{param_def}{$param}{array}\n";
						} else {
							die "No value found for constant: $const_name\n";
						}
					} else {
						$pbat->{$cmd}{param_def}{$param}{array} = $_;						
							print STDERR "Warning: Magic numbers in used ($pbat->{$cmd}{param_def}{$param}{array}) \t($cmd, $param): \n";
						next;
					}
					if(exists $const{$const_name}) {
						if($const{$const_name} != $const_value) {
							die "multiple constant definition with different values '$const_name' = ($const{$const_name} != $const_value)";
						}
						next;
					}
					$const{$const_name} = $const_value;

print STDERR "Warning: Constand value name breaks the naming rule ($const_name -> MAX_...).\t($cmd, $param)\n" if(! ($const_name =~ /^MAX/));

$debug .= <<HERE_TARGET;
        <Constant>
            <Alias>$const_name</Alias>
            <Value ValueType="DEC">$const_value</Value>
            <Comment>Constant element</Comment>
        </Constant>
HERE_TARGET
	}	} else { #BUGFIX version 1.0: Structure level linked arrays
			my $type;
			for $type (sort grep /set|query|uns|test/, keys %{$pbat->{$cmd}}) {
				if(defined $pbat->{$cmd}{$type}{param_def}{$param}{type}) {
					if($pbat->{$cmd}{$type}{param_def}{$param}{type} =~ /(\[.+\])/) {
						print "$cmd $type\n";
						local $_ = uc $1;
						if(/([A-Z][A-Z_0-9]+)/) {
							$const_name = $1;
							if(/=(.+?)\]/) {
								$const_value = $1;
								if($const_value =~ /(\d+)\.+(\d+)/) {
									$const_value = $2;
									$pbat->{$cmd}{$type}{param_def}{$param}{array} = "[$1..$const_name]"; 
								} else {
									if(/\[(\d+)\.+/) {
										$pbat->{$cmd}{$type}{param_def}{$param}{array} = "[$1..$const_name]"
									} else {
										$pbat->{$cmd}{$type}{param_def}{$param}{array} = "[$const_name]";
									}
								}
								if(/\[.+?\](\[.+\])/) {
									$pbat->{$cmd}{$type}{param_def}{$param}{array} .= $1;
								}
								#print STDERR "$pbat->{$cmd}{param_def}{$param}{array}\n";
							} else {
								die "No value found for constant: $const_name\n";
							}
						} else {
							$pbat->{$cmd}{$type}{param_def}{$param}{array} = $_;						
								print STDERR "Warning: Magic numbers in used ($pbat->{$cmd}{param_def}{$param}{array}) \t($cmd, $param): \n";
							next;
						}
						if(exists $const{$const_name}) {
							if($const{$const_name} != $const_value) {
								die "multiple constant definition with different values '$const_name' = ($const{$const_name} != $const_value)";
							}
							next;
						}
						$const{$const_name} = $const_value;
						
print STDERR "Warning: Constand value name breaks the naming rule ($const_name -> MAX_...).\t($cmd, $param)\n" if(! ($const_name =~ /^MAX/));

$debug .= <<HERE_TARGET;
        <Constant>
            <Alias>$const_name</Alias>
            <Value ValueType="DEC">$const_value</Value>
            <Comment>Constant element</Comment>
        </Constant>
HERE_TARGET
					}
				} 
			}
	}
	
	
	}	}
	
$debug .= <<HERE_TARGET;
        <History>
            <Date Day="03" Month="02" Year="2005"/>
            <Author>BRZ</Author>
            <Comment>Initial</Comment>
        </History>
    </ConstantsSection>
HERE_TARGET
	$debug;
}
sub print_values(\%) {
	my $ph = shift;
	
	$ph->{description}  ||= $ph->{description}= 'Value List';
	$ph->{comment}      ||= $ph->{comment}    = 'Values';
	
my $debug .= <<HERE_TARGET;
        <Values>
            <Description>
                <DocElement>
                <XHTMLElement Type="TEXT_SECTION">$ph->{description}</XHTMLElement>
                </DocElement>
            </Description>
            <ValuesDef>
                <Name>$ph->{name}</Name>
                <Comment>$ph->{comment}</Comment>
            </ValuesDef>
HERE_TARGET

	for(@{$ph->{values}}) {
		$_->{type}         ||= $_->{type}       = 'DEC';
		$_->{comment}      ||= $_->{comment}    = 'Value';
		
$debug .= <<HERE_TARGET;
            <ValuesItem>
                <Value ValueType="$_->{type}">$_->{value}</Value>
                <Alias>$_->{alias}</Alias>
                <Comment>$_->{comment}</Comment>
            </ValuesItem>
HERE_TARGET
	}	

$debug .= <<HERE_TARGET;
           <History>
                <Date Day=\"03\" Month=\"02\" Year=\"2005\"/>
                <Author>BRZ</Author>
                <Comment>Initial</Comment>
            </History>
        </Values>
HERE_TARGET

			$debug;
}

sub bat_ValuesSection(\%) {
	#no warnings;
	my $pbat = shift;
	my ($cmd, $param);

my $debug = <<HERE_TARGET;
    <ValuesSection>
        <Description>
            <DocElement>
                <XHTMLElement Type="TEXT_SECTION">This section contains all sets of values that are defined for the BAT SAP.</XHTMLElement>
            </DocElement>
        </Description>
HERE_TARGET
	
	for $cmd (sort ATsort keys %{$pbat}) {
		#print STDERR "$cmd\t";
		for $param (sort ATsort keys %{$pbat->{$cmd}{param_def}}) {
			if(! exists $pbat->{$cmd}{param_def}{$param}{ref} && exists $pbat->{$cmd}{value_def}{$param}) {
				my %value_list;
				my $alias_prefix = uc "$pbat->{$cmd}{param_def}{$param}{short}_" if($pbat->{$cmd}{param_def}{$param}{short} ne '@empty');
				$value_list{name} = VAL_name $cmd, $param;
				$value_list{description} = xml_adaptation $pbat->{$cmd}{param_def}{$param}{descr};
				next if(! defined $value_list{name} || ! defined  $value_list{description});
				print STDERR "Warning: The description includes quetionmarks ($value_list{description}).\n" if($value_list{description} =~ /\?/);
				#print STDERR "$value_list{name}, $description\n";

				my $pvalue; my $i = 0;

				if(exists $enum{$value_list{name}}) {
					$value_list{values}[0]{comment} = 'This indicates that the value is omitted.';
					$value_list{values}[0]{alias}   = $alias_prefix . 'NOT_PRESENT';
					$value_list{values}[0]{alias}   = uc shortCmd2Name($cmd) . "_" . $value_list{values}[0]{alias} if($cmd ne "shared");
					$value_list{values}[0]{value}   = -1;
					$i++;
				}
				for $pvalue (@{$pbat->{$cmd}{value_def}{$param}}) {
					if (defined $pvalue) {
						$value_list{values}[$i]{comment} = xml_adaptation $pvalue->{long};
						print STDERR "Warning: The description includes quetionmarks ($value_list{values}[$i]{comment}).\n" if($value_list{values}[$i]{comment} =~ /\?/);

						$value_list{values}[$i]{alias}  = $alias_prefix;
						$value_list{values}[$i]{alias} .= uc "$pvalue->{short}";
						$value_list{values}[$i]{alias}  = uc shortCmd2Name($cmd) . "_" . $value_list{values}[$i]{alias} if($cmd ne "shared");
						
						$value_list{values}[$i]{value} = $pvalue->{value};
					$i++;
				}	}
				$debug .= print_values %value_list;
	 }	}	}

$debug .= <<HERE_TARGET;
        <Values>
            <Description>
                <DocElement>
                <XHTMLElement Type="TEXT_SECTION">This is a dummy value entry which will be never used for communication with BAT.</XHTMLElement>
                </DocElement>
            </Description>
            <ValuesDef>
                <Name>VAL_bat_dummy</Name>
                <Comment>Values</Comment>
            </ValuesDef>
            <ValuesItem>
                <Value ValueType="DEC">0</Value>
                <Alias>DUMMY</Alias>
                <Comment>dummy value</Comment>
            </ValuesItem>
            <History>
                <Date Day="03" Month="02" Year="2005"/>
                <Author>BRZ</Author>
                <Comment>Initial</Comment>
            </History>
        </Values>
    </ValuesSection>
HERE_TARGET

$debug;
}

sub print_basic_element(\%) {
	my $ph = shift;
	
	$ph->{type}         ||= $ph->{type}       = 'U8';
	$ph->{link}{type}   ||= $ph->{link}{type} = 'SAP';
	$ph->{link}{doc}    ||= $ph->{link}{doc}  = 'bat';
	$ph->{comment}      ||= $ph->{comment}    = 'Basic Element';
	$ph->{description}  ||= $ph->{description}= $ph->{comment};
	
my $debug .= <<HERE_TARGET;
        <PrimBasicElem>
            <Description>
                <DocElement>
                <XHTMLElement Type="TEXT_SECTION">$ph->{description}</XHTMLElement>
                </DocElement>
            </Description>
            <PrimBasicElemDef>
                <Name>$ph->{name}</Name>
                <Type>$ph->{type}</Type>
                <Comment>$ph->{comment}</Comment>
            </PrimBasicElemDef>
HERE_TARGET

if(exists $ph->{link}{name}) {
$debug .= <<HERE_TARGET;
            <ValuesLink>
                <DocName DocType="$ph->{link}{type}">$ph->{link}{doc}</DocName>
                <Name>$ph->{link}{name}</Name>
            </ValuesLink>
HERE_TARGET
}

$debug .= <<HERE_TARGET;
            <History>
                <Date Day="03" Month="02" Year="2005"/>
                <Author>BRZ</Author>
                <Comment>Initial</Comment>
            </History>
        </PrimBasicElem>
HERE_TARGET
			$debug;
}


sub bat_PrimBasicElementsSection(\%) {
	my $pbat = shift;
	my ($cmd, $param);

sub convert_valueless_parameter_type($$$) {
	local $_= shift;
	my ($cmd, $param) = @_;

	print STDERR "Warning: There is a signed value in the syntax file ($cmd, $param)!\n" if(/S/);
	
	s/U/S/;
	/(\d+)/;
	
	return 'S16' if($1 ==  8);
	return 'S32' if($1 == 16);
	
	$_;
}

my $debug = <<HERE_TARGET;
    <PrimBasicElementsSection>
        <Description>
            <DocElement>
                <XHTMLElement Type="TEXT_SECTION">This section describes all parameters of the AT commands in the BAT SAP.</XHTMLElement>
            </DocElement>
        </Description>
HERE_TARGET
##############################################################
	my $VAL_link = '';
	for $cmd (sort ATsort keys %{$pbat}) {
		for $param (sort ATsort keys %{$pbat->{$cmd}{param_def}}) {
			if(! exists $pbat->{$cmd}{param_def}{$param}{ref}) {
				my %basic;

				$basic{comment} = xml_adaptation $pbat->{$cmd}{param_def}{$param}{descr};
				if(! defined  $basic{comment}) {
					# brz:
					#print STDERR "Warning: Missing description ($cmd, $param)\n";
					next;
				} else {
					#print STDERR "No Warning: Missing description ($cmd, $param)\n";
				}
				
				print STDERR "Warning: The description includes quetionmarks ($basic{comment}).\n" if($basic{comment} =~ /\?/);

				$basic{name} = element_name($cmd, $param);
				$basic{type} = basisTyp $cmd, $pbat->{$cmd}{param_def}{$param}{type};
				#print STDERR "*$pbat->{$cmd}{param_def}{$param}{type}*$Type*\t";
				my $VAL_link = '';
				
				if (exists $pbat->{$cmd}{value_def}{$param}) {
					#link zu vals herstellen
					$basic{type} = 'ENUM' if($use_enum);
					my $VAL_NAME = VAL_name $cmd, $param;
					$VAL_link = '';				
					next if(! defined $VAL_NAME);
					$basic{link}{name} = $VAL_NAME;
				}

# Korrektur fr optional mandatory problem

if(exists $basic{link}{name}) {  # if enum 
	if(exists $enum{$basic{name}}{opt}) {
		$enum{$basic{link}{name}} = 1;
	}
$debug .= print_basic_element %basic;
} else {
	if(exists $param{$basic{name}}) {
		#print "$basic{name}: ", keys %{$param{$basic{name}}}, "\n";
		if(exists $param{$basic{name}}{man}) {			
			my $temp = $basic{name};
			$basic{name} .= '_man';
			$debug .= print_basic_element %basic;
			$basic{name} = $temp;
		}
		if(exists $param{$basic{name}}{opt}) {
			$basic{type} = convert_valueless_parameter_type $basic{type}, $cmd, $param;
			$basic{name} .= '_opt';
			
			$debug .= print_basic_element %basic;
		}
	}elsif(exists $array{$basic{name}}) {
		$debug .= print_basic_element %basic;
	} else {
		print STDERR "Warning: Global defined parameter '$basic{name}' is not used.\n";
	}
}
								
}}}


##############################################################
$debug .= <<HERE_TARGET;
        <PrimBasicElem>
            <Description>
                <DocElement>
                <XHTMLElement Type="TEXT_SECTION">This parameter is only needed to describe AT commands without parameter.</XHTMLElement>
                </DocElement>
            </Description>
            <PrimBasicElemDef>
                <Name>bat_dummy</Name>
                <Type>U8</Type>
                <Comment>dummy parameter</Comment>
            </PrimBasicElemDef>
            <ValuesLink>
                <DocName DocType="SAP">bat</DocName>
                <Name>VAL_bat_dummy</Name>
            </ValuesLink>
            <History>
                <Date Day="03" Month="02" Year="2005"/>
                <Author>BRZ</Author>
                <Comment>Initial</Comment>
            </History>
        </PrimBasicElem>
    </PrimBasicElementsSection>
HERE_TARGET
			$debug;
}


sub bat_PrimStructElementsSection(\%) {
	#no warnings;
	my $pbat = shift;
	my ($cmd, $param, $type);

my $debug = <<HERE_TARGET;
    <PrimStructElementsSection>
        <Description>
            <DocElement>
                <XHTMLElement Type="TEXT_SECTION">This section describes all structures and enumeration tags to identify the binary AT command and there paramter.</XHTMLElement>
            </DocElement>
        </Description>
        <PrimStructElem>
            <Description>
                <DocElement>
                    <XHTMLElement Type="TEXT_SECTION">This is a container for the binary AT command to send.</XHTMLElement>
                </DocElement>
                <DocElement>
                    <XHTMLElement Type="TEXT_SECTION"> It consists out of an enumeration to select the right type and a union of pointers to structures of the actual binary AT command.</XHTMLElement>
                </DocElement>
            </Description>
            <PrimStructElemDef Type="STRUCT">
                <Name>cmd_send</Name>
                <Comment>Structure for sending BAT commands</Comment>
            </PrimStructElemDef>
            <PrimStructElemItem Presentation="MANDATORY">
                <ItemLink>
                    <DocName DocType="SAP">bat</DocName>
                    <Name>params</Name>
                </ItemLink>
                <Comment>Primitive structure element item</Comment>
            </PrimStructElemItem>
            <History>
                <Date Day="03" Month="02" Year="2005"/>
                <Author>BRZ</Author>
                <Comment>Initial</Comment>
            </History>
        </PrimStructElem>
        <PrimStructElem>
            <Description>
                <DocElement>
                    <XHTMLElement Type="TEXT_SECTION"/>
                </DocElement>
            </Description>
            <PrimStructElemDef Type="STRUCT">
                <Name>cmd_response</Name>
                <Comment>Structure for receiving BAT responses</Comment>
            </PrimStructElemDef>
            <PrimStructElemItem Presentation="MANDATORY">
                <ItemLink>
                    <DocName DocType="SAP">bat</DocName>
                    <Name>response</Name>
                </ItemLink>
                <Comment>Primitive structure element item</Comment>
            </PrimStructElemItem>
            <History>
                <Date Day="03" Month="02" Year="2005"/>
                <Author>BRZ</Author>
                <Comment>Initial</Comment>
            </History>
        </PrimStructElem>
HERE_TARGET
############################################
	#
	#	a dummy structure
	#############################
	{
		my %item;
	
		$item{sections}[0] = 'This dummy structure for AT commands which needs no parameters. This structure needs never be used!';
		$item{name}                   = 'no_parameter';
		$item{comment}                = 'Dummy structure';
		$item{items}[0]{link}{doc}    = 'bat';
		$item{items}[0]{link}{name}   = 'bat_dummy';
		$item{items}[0]{presentation} = 'MANDATORY';
		$debug .= print_structured_element %item;
	}	
########################################################
	#
	#	command / response  structures
	##########################################
#cmd_set_P..
#cmd_que
#cmd_tst
#cmd_andF
#cmd_atF
	my ($occurance, $isArray, $isEnum);
	my %type_text = ('set' => 'set command',  'set rsp' => 'set response',  'query' => 'query answer',  'uns' => 'unsolicited result code',  'test' => 'test answer');
	for $cmd (sort ATsort keys %{$pbat}) {
		for $type (sort grep /set|query|uns|test/, keys %{$pbat->{$cmd}}) {
			my %item;
			$item{sections}[0] = $pbat->{$cmd}{descr};
			$item{name}        = lc get_prim_id $cmd, $type;
			$item{comment}     = xml_adaptation "The $type_text{$type} structure of the $cmd command.";
			#print STDERR "$type\n";
			my $i = 0;
			if(exists $pbat->{$cmd}{$type}{params}) {
				for $param ( @{$pbat->{$cmd}{$type}{params}}) {
					undef $occurance;
					if(exists $pbat->{$cmd}{param_def}{$param}{ref}) {
						my $ref_to    = $pbat->{$cmd}{param_def}{$param}{ref};
						my $ref_param = $param;
						$ref_param = $pbat->{$cmd}{param_def}{$param}{ref_name} if(exists $pbat->{$cmd}{param_def}{$param}{ref_name});
						$item{items}[$i]{comment} = xml_adaptation $pbat->{$ref_to}{param_def}{$ref_param}{descr};
						$item{items}[$i]{comment} = xml_adaptation $pbat->{$cmd}{param_def}{$param}{descr} if(exists $pbat->{$cmd}{param_def}{$param}{descr});
						$item{items}[$i]{comment} = xml_adaptation $pbat->{$ref_to}{param_def}{$ref_param}{descr};
		
						$occurance = $pbat->{$cmd}{$type}{param_def}{$param}{occu} if(defined $pbat->{$cmd}{$type}{param_def}{$param}{occu});
						$item{items}[$i]{comment} = (defined $occurance && $occurance eq 'opt' ? "Optional : " : "Mandatory: ") . $item{items}[$i]{comment};
						$item{items}[$i]{presentation} = defined $occurance && $occurance eq 'opt'? 'OPTIONAL' : 'MANDATORY';

						$item{items}[$i]{link}{doc} = 'bat';
						$item{items}[$i]{link}{name} = element_name($ref_to, $ref_param);
						$item{items}[$i]{alias} = $param;


						if (exists $pbat->{$cmd}{param_def}{$param}{rename}) {
						} else {
							#$item{items}[$i]{alias} = $ref_param;
						}
						#$item{items}[$i]{presentation} = defined $pbat->{$cmd}{$type}{param_def}{$param}{occu} && $pbat->{$cmd}{$type}{param_def}{$param}{occu} eq 'opt'? 'OPTIONAL' : 'MANDATORY';

						
						
						# everything is mandatory with the execption of may be strings
						if (! defined $pbat->{$ref_to}{param_def}{$ref_param}{array} && ! defined $pbat->{$cmd}{param_def}{$param}{array}) {
							$item{items}[$i]{presentation} = 'MANDATORY';
 							$isArray = 0;
						} else {
							$isArray = 1;
						}
						if (exists $pbat->{$ref_to}{value_def}{$ref_param}) {
							$isEnum = 1;
						} else {
							$isEnum = 0;
						}
						
						$item{items}[$i]{control} = $pbat->{$ref_to}{param_def}{$ref_param}{array} if (defined $pbat->{$ref_to}{param_def}{$ref_param}{array});
						$item{items}[$i]{control} = $pbat->{$cmd}{param_def}{$param}{array} if (defined $pbat->{$cmd}{param_def}{$param}{array});
						$item{items}[$i]{control} = $pbat->{$cmd}{$type}{param_def}{$param}{array} if (defined $pbat->{$cmd}{$type}{param_def}{$param}{array});
					} else {
						$item{items}[$i]{comment} = xml_adaptation $pbat->{$cmd}{param_def}{$param}{descr};

						$occurance = $pbat->{$cmd}{param_def}{$param}{occu} if(defined $pbat->{$cmd}{param_def}{$param}{occu});
						$occurance = $pbat->{$cmd}{$type}{param_def}{$param}{occu} if(defined $pbat->{$cmd}{$type}{param_def}{$param}{occu});
						$item{items}[$i]{comment} = (defined $occurance && $occurance eq 'opt' ? "Optional : " : "Mandatory: ") . $item{items}[$i]{comment};
						
						#next if(! defined  $description);
						$item{items}[$i]{link}{doc} = 'bat';
						$item{items}[$i]{link}{name} = element_name($cmd, $param);
						$item{items}[$i]{alias} = $param;
						$item{items}[$i]{presentation} = defined $occurance && $occurance eq 'opt'? 'OPTIONAL' : 'MANDATORY';

						# everything is mandatory with the execption of may be strings
						if (! defined $pbat->{$cmd}{param_def}{$param}{array}) {
							$item{items}[$i]{presentation} = 'MANDATORY';
 							$isArray = 0;
						} else {
							$isArray = 1;
						}
						if (exists $pbat->{$cmd}{value_def}{$param}) {
							$isEnum = 1;
						} else {
							$isEnum = 0;
						}
						$item{items}[$i]{control} = $pbat->{$cmd}{param_def}{$param}{array} if (defined $pbat->{$cmd}{param_def}{$param}{array});
					}
					if(exists $item{items}[$i]{control} && $item{items}[$i]{control} =~ /\.\./ && $item{items}[$i]{presentation} eq 'OPTIONAL') {
						print STDERR "TBC: May be duplicated information - variable length and valid flag defined ($cmd, $type, $param).\n";
					}
					if(exists $item{items}[$i]{control} && !($item{items}[$i]{control} =~ /[\.]/) && $item{items}[$i]{presentation} eq 'MANDATORY') {
						print STDERR "$item{items}[$i]{control}\n";
						print STDERR "TBC: Array has no variable length - ($cmd, $type, $param).\n";
					}
					# Korrektur fr mandatory - optional problem
					if(!defined $occurance) {
						$occurance = 'man';
						print STDERR "Warning undefined occurance of parameter, mandatory assumed: $cmd - $param\n";						
					}
					if($isEnum) {
						$enum{$item{items}[$i]{link}{name}}{$occurance} = 1;
					} elsif(! $isArray) { # parameter without value definition
						$param{$item{items}[$i]{link}{name}}{$occurance} = 1;
						$item{items}[$i]{link}{name} .= "_$occurance";
						#print "$item{items}[$i]{link}{name}\n";
					} else{
						$array{$item{items}[$i]{link}{name}}=1;
					}
					
					$i++;
				}
				$debug .= print_structured_element %item;
			}
		}
	}

############################################
	#
	#	params union
	#########################
	{
		my %item;
		my ($c_param, $c_no_param) = (0, 4096);
		my ($name, $alias);
		$item{sections}[0] = 'This enumeration describes a pointer to the requested AT command describtion.';
		$item{name} = 'params';
		$item{type} = 'UNION';
		
		#all commands with parameter
		for $cmd (sort ATsort keys %{$pbat}) {
			for $type (grep /^set$/, keys %{$pbat->{$cmd}}) {
				if (exists $pbat->{$cmd}{$type}{params}) {
					$name = get_prim_id $cmd, $type;
					$alias = $name;
					$alias =~ s/CMD_//;
					$item{items}[$c_param]{presentation} = 'MANDATORY';
					$item{items}[$c_param]{comment}      = 'points to the corresponding parameter structure';
					$item{items}[$c_param]{control}      = 'PTR';
					$item{items}[$c_param]{link}{doc}    = 'bat';
					$item{items}[$c_param]{link}{name}   = lc $name;
					$item{items}[$c_param]{union}{name}  = $name;
					$item{items}[$c_param]{union}{id}    = $c_param;
					$item{items}[$c_param]{alias}        = lc $alias; #'set_' . lc cmd2Name $cmd;
					$c_param++;
		}	}	}
		
		#all commands without parameter, currently only basic commands
		for $cmd (sort ATsort keys %{$pbat}) {
			for $type (grep /^set$/, keys %{$pbat->{$cmd}}) {
				#print STDERR "$cmd $type\n";
				if (!exists $pbat->{$cmd}{$type}{params}) {
				#print STDERR "2\n";
					$name = get_prim_id $cmd, $type;
					$alias = $name;
					$alias =~ s/CMD_//;
					$item{items}[$c_param]{presentation} = 'MANDATORY';
					$item{items}[$c_param]{comment}      = 'pointer needs not to be used';
					$item{items}[$c_param]{control}      = 'PTR';
					$item{items}[$c_param]{link}{doc}    = 'bat';
					$item{items}[$c_param]{link}{name}   = 'no_parameter';
					$item{items}[$c_param]{union}{name}  = $name;
					$item{items}[$c_param]{union}{id}    = $c_no_param;
					$item{items}[$c_param]{alias}        = lc $alias; #cmd2Name $cmd;
					$c_param++;$c_no_param++;
		}	}	}

		# now really query test!!!
		for $cmd (sort ATsort keys %{$pbat}) {
			for $type (grep /query|test/, keys %{$pbat->{$cmd}}) {
				#print STDERR "1: $cmd $type\n";
				$name = get_prim_id $cmd, $type;
				$name =~ s/RES/CMD/;
				$alias = $name;
				$alias =~ s/CMD_//;
				#print STDERR "2: $alias $name\n";
				$item{items}[$c_param]{presentation} = 'MANDATORY';
				$item{items}[$c_param]{comment}      = 'pointer needs not to be used';
				$item{items}[$c_param]{control}      = 'PTR';
				$item{items}[$c_param]{link}{doc}    = 'bat';
				$item{items}[$c_param]{link}{name}   = 'no_parameter';
				$item{items}[$c_param]{union}{name}  = $name;
				$item{items}[$c_param]{union}{id}    = $c_no_param;
				$item{items}[$c_param]{alias}        = lc $alias; #cmd2Name $cmd;
				$c_param++;$c_no_param++;
		}	}
		$debug .= print_structured_element %item;
	}
############################################
	#
	#	response union
	#########################
	{
		my %item;
		my ($c_param, $c_no_param) = (0, 4096);
		my $name;
		$item{sections}[0] = 'This enumeration describes pointers to all AT command response describtions.';
		$item{name} = 'response';
		$item{type} = 'UNION';
		
sub Basicsort {
	my %rang = ('OK'=>0, 'CONNECT'=>1, 'NO_CARRIER_final'=>2, '+CME_ERROR'=>4, '+CMS_ERROR'=>5, 'BUSY'=>6, 'NO_ANSWER'=>7, 'NO_CARRIER_intermediate'=>8, '+CRING'=>9, '+CCWV'=>10);
	#print STDERR "$a\t";
	$rang{$a} <=> $rang{$b}; 
}
                # mostly the BASIC types
		for $cmd (sort Basicsort grep /BUSY|CONNECT|NO_ANSWER|NO_CARRIER|OK|CM._ERROR|\+CRING|\+CCWV/, keys %{$pbat}) {
			$name = get_prim_id $cmd, 'uns';
			my $alias = $name;
			$alias =~ s/RES_//;
			$alias =~ s/UNS_//;
			$item{items}[$c_param]{presentation} = 'MANDATORY';
			$item{items}[$c_param]{control}      = 'PTR';
			$item{items}[$c_param]{link}{doc}    = 'bat';
			$item{items}[$c_param]{union}{name}  = $name;
			$item{items}[$c_param]{union}{id}    = $c_param;
			$item{items}[$c_param]{alias}        = lc $alias;

			if (exists $pbat->{$cmd}{uns}{params}) {
				$item{items}[$c_param]{link}{name}   = lc $name;
			} else {
				$item{items}[$c_param]{link}{name}   = 'no_parameter';
			}
			$c_param++;
		}	

                # intermediate
		for $cmd (sort ATsort keys %{$pbat}) {
			next if($cmd =~ /BUSY|CONNECT|NO_ANSWER|NO_CARRIER|OK|CM._ERROR|\+CRING|\+CCWV|shared|query|set|set rsp|test|uns/);
			for $type (grep /query|test|set rsp/, keys %{$pbat->{$cmd}}) {
				$name = get_prim_id $cmd, $type;
				#print STDERR "$cmd\t";
				my $alias = $name;
				$alias =~ s/RES_//;
				#$alias =~ s/UNS_//;
				$item{items}[$c_param]{presentation} = 'MANDATORY';
				$item{items}[$c_param]{control}      = 'PTR';
				$item{items}[$c_param]{link}{doc}    = 'bat';
				$item{items}[$c_param]{union}{name}  = $name;
				$item{items}[$c_param]{union}{id}    = $c_param;
				$item{items}[$c_param]{alias}        = lc $alias;
	
				if (exists $pbat->{$cmd}{$type}{params}) {
					$item{items}[$c_param]{link}{name}   = lc $name;
				} else {
					$item{items}[$c_param]{link}{name}   = 'no_parameter';
				}
				$c_param++;
			}
		}	

                # unsolicited
		for $cmd (sort ATsort keys %{$pbat}) {
			next if($cmd =~ /BUSY|CONNECT|NO_ANSWER|NO_CARRIER|OK|CM._ERROR|\+CRING|\+CCWV|shared|query|set|set rsp|test|uns/);
			for $type (grep /uns/, keys %{$pbat->{$cmd}}) {
				$name = get_prim_id $cmd, $type;
				#print STDERR "$cmd\t";
				my $alias = $name;
				#$alias =~ s/RES_//;
				$alias =~ s/UNS_//;
				$item{items}[$c_param]{presentation} = 'MANDATORY';
				$item{items}[$c_param]{comment}      = 'points to the corresponding parameter structure';
				$item{items}[$c_param]{control}      = 'PTR';
				$item{items}[$c_param]{link}{doc}    = 'bat';
				$item{items}[$c_param]{union}{name}  = $name;
				$item{items}[$c_param]{union}{id}    = $c_no_param;
				$item{items}[$c_param]{alias}        = lc $alias;
	
				if (exists $pbat->{$cmd}{$type}{params}) {
					$item{items}[$c_param]{link}{name}   = lc $name;
				} else {
					$item{items}[$c_param]{link}{name}   = 'no_parameter';
				}
				$c_param++;$c_no_param++;
			}
		}	
		
		$debug .= print_structured_element %item;
	}

############################################
	$debug .= "    </PrimStructElementsSection>\n";
}

sub print_structured_element(\%) {
	my $ph = shift;
	my $todo;
	
	$ph->{type}         ||= $ph->{type} = 'STRUCT';
	$ph->{comment}      ||= $ph->{comment} = 'Structured Element';
#	$ph->{presentation} ||= $ph->{presentation} = 'MANDATORY';
	
my $debug = <<HERE_TARGET;
        <PrimStructElem>
            <Description>
HERE_TARGET
	$todo = 1;
	for(@{$ph->{sections}}) {
		$debug .= "                <Section>$_</Section>\n";
		$todo = 0;
	}
		$debug .= "                <Section/>\n" if($todo);
$debug .= <<HERE_TARGET;
            </Description>
            <PrimStructElemDef Type="$ph->{type}">
                <Name>$ph->{name}</Name>
                <Comment>$ph->{comment}</Comment>
            </PrimStructElemDef>
HERE_TARGET
	for(@{$ph->{items}}) {
		$_->{presentation} ||= $_->{presentation} = 'OPTIONAL';
		$_->{link}{type}   ||= $_->{link}{type} = 'SAP';
		$_->{comment}      ||= $_->{comment} = 'Primitive structure element item';

#print STDERR "$_->{union}\n" if(defined $_->{union});

$debug .= <<HERE_TARGET;
	    <PrimStructElemItem Presentation="$_->{presentation}">
	        <ItemLink>
	            <DocName DocType="$_->{link}{type}">$_->{link}{doc}</DocName>
	            <Name>$_->{link}{name}</Name>
	        </ItemLink>
HERE_TARGET
$debug .= "                <Alias>$_->{alias}</Alias>\n" if(defined $_->{alias});

if(defined $_->{union}) {
$debug .= <<HERE_TARGET;
	        <UnionTag>
	            <Name>$_->{union}{name}</Name>
	            <Value ValueType="DEC">$_->{union}{id}</Value>
	        </UnionTag>
HERE_TARGET
}

$debug .= "	        <Control>$_->{control}</Control>\n" if(defined $_->{control});
$debug .= "	        <Version>$_->{version}</Version>\n" if(defined $_->{version});
$debug .= "	        <Comment>$_->{comment}</Comment>\n";
$debug .= "</PrimStructElemItem>\n";
	}

$debug .= <<HERE_TARGET;
            <History>
                <Date Day="03" Month="02" Year="2005"/>
                <Author>BRZ</Author>
                <Comment>Initial</Comment>
            </History>
        </PrimStructElem>
HERE_TARGET
$debug;
}

__END__

        
